<?php
/* --------------------------------------------------------------
   UserId.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission\Model;

use Webmozart\Assert\Assert;

/**
 * Class UserId
 *
 * @package Gambio\Core\Auth\Model
 */
class UserId implements \Gambio\Core\Auth\UserId
{
    /**
     * @var int
     */
    private $value;
    
    
    /**
     * UserId constructor.
     *
     * @param int $value
     */
    private function __construct(int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * Creates and returns a new instance of the UserId.
     *
     * @param int $value
     *
     * @return UserId
     */
    public static function create(int $value): UserId
    {
        Assert::greaterThan($value, 0, 'The user id must be a positive integer. Got: %s');
        
        return new self($value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function userId(): int
    {
        return $this->value;
    }
}